package fr.asip.cps3.exemple.modele.exceptions;


/**
 * Classe d'exception applicative intervenant lors de la construction ou de la mise  jour d'un objet
 */
public class ExceptionObjet extends ExceptionProgrammeExemple {

	private static final long serialVersionUID = 8961069070532248700L;
	
	/**
	 * Code du type d'objet
	 */
	private int typeObjet = -1;
	
	/**
	 * Constructeur
	 * @param typeObjet
	 */
	public ExceptionObjet(int typeObjet) {
		super();
		this.typeObjet = typeObjet;
	}

	/**
	 * Constructeur
	 * @param typeObjet Code de type d'objet 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionObjet(int typeObjet, String message, Throwable cause) {
		super(message, cause);
		this.typeObjet = typeObjet;
	}

	/**
	 * Constructeur
	 * @param typeObjet Code du type d'objet 
	 * @param message Intitul de l'exception
	 */
	public ExceptionObjet(int typeObjet, String message) {
		super(message);
		this.typeObjet = typeObjet;
	}

	/**
	 * Constructeur
	 * @param typeObjet Code du type d'objet 
	 * @param message Intitul de l'exception
	 * @param cause Cause de l'exception
	 */
	public ExceptionObjet(int typeObjet, Throwable cause) {
		super(cause);
		this.typeObjet = typeObjet;
	}

	/**
	 * Accesseur
	 * @return le code de type d'objet
	 */
	public int getTypeObjet() {
		return typeObjet;
	}

	/**
	 * Dtermine le type d'exception
	 * @return Le type d'exception
	 */
	public String getTypeException() {
		
		switch(typeObjet) {
		
			case ExceptionProgrammeExemple.TYPE_OBJET_ALGORITHME:
				return ("Erreur algorithme");

			case ExceptionProgrammeExemple.TYPE_OBJET_CLE:
				return ("Erreur cl");

			case ExceptionProgrammeExemple.TYPE_OBJET_OBJET:
				return ("Erreur objet de donnes applicatives");

			case ExceptionProgrammeExemple.TYPE_OBJET_SLOT:
				return ("Erreur slot");

			case ExceptionProgrammeExemple.TYPE_OBJET_TOKEN:
				return ("Erreur carte");

			case ExceptionProgrammeExemple.TYPE_OBJET_SESSION:
				return ("Erreur session");
				
			default:
				return "Erreur objet";
		}
			
	}
	
}
